package zio.aws.opsworkscm
import zio.aws.opsworkscm.model.{
  DisassociateNodeRequest,
  CreateBackupRequest,
  DescribeEventsRequest,
  ListTagsForResourceRequest,
  DescribeServersRequest,
  DeleteServerRequest,
  ExportServerEngineAttributeRequest,
  StartMaintenanceRequest,
  DescribeNodeAssociationStatusRequest,
  UpdateServerRequest,
  DeleteBackupRequest,
  UntagResourceRequest,
  DescribeAccountAttributesRequest,
  CreateServerRequest,
  UpdateServerEngineAttributesRequest,
  DescribeBackupsRequest,
  AssociateNodeRequest,
  TagResourceRequest,
  RestoreServerRequest
}
import zio.aws.opsworkscm.model.CreateServerResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object OpsWorksCmMock extends Mock[OpsWorksCm] {
  object UpdateServer
      extends Effect[
        UpdateServerRequest,
        AwsError,
        zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly
      ]
  object DeleteServer
      extends Effect[
        DeleteServerRequest,
        AwsError,
        zio.aws.opsworkscm.model.DeleteServerResponse.ReadOnly
      ]
  object ExportServerEngineAttribute
      extends Effect[
        ExportServerEngineAttributeRequest,
        AwsError,
        zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly
      ]
  object AssociateNode
      extends Effect[
        AssociateNodeRequest,
        AwsError,
        zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly
      ]
  object CreateBackup
      extends Effect[
        CreateBackupRequest,
        AwsError,
        zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly
      ]
  object DescribeNodeAssociationStatus
      extends Effect[
        DescribeNodeAssociationStatusRequest,
        AwsError,
        zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly
      ]
  object DescribeBackups
      extends Stream[
        DescribeBackupsRequest,
        AwsError,
        zio.aws.opsworkscm.model.Backup.ReadOnly
      ]
  object DescribeBackupsPaginated
      extends Effect[
        DescribeBackupsRequest,
        AwsError,
        zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly
      ]
  object RestoreServer
      extends Effect[
        RestoreServerRequest,
        AwsError,
        zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.opsworkscm.model.UntagResourceResponse.ReadOnly
      ]
  object DisassociateNode
      extends Effect[
        DisassociateNodeRequest,
        AwsError,
        zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly
      ]
  object DescribeServers
      extends Stream[
        DescribeServersRequest,
        AwsError,
        zio.aws.opsworkscm.model.Server.ReadOnly
      ]
  object DescribeServersPaginated
      extends Effect[
        DescribeServersRequest,
        AwsError,
        zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly
      ]
  object DeleteBackup
      extends Effect[
        DeleteBackupRequest,
        AwsError,
        zio.aws.opsworkscm.model.DeleteBackupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.opsworkscm.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.opsworkscm.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateServer extends Effect[CreateServerRequest, AwsError, ReadOnly]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.opsworkscm.model.TagResourceResponse.ReadOnly
      ]
  object StartMaintenance
      extends Effect[
        StartMaintenanceRequest,
        AwsError,
        zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly
      ]
  object UpdateServerEngineAttributes
      extends Effect[
        UpdateServerEngineAttributesRequest,
        AwsError,
        zio.aws.opsworkscm.model.UpdateServerEngineAttributesResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.opsworkscm.model.ServerEvent.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, OpsWorksCm] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, OpsWorksCm] { rts =>
        zio.ZIO.succeed {
          new OpsWorksCm {
            val api: OpsWorksCmAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): OpsWorksCm = this
            def updateServer(request: UpdateServerRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly
            ] = proxy(UpdateServer, request)
            def deleteServer(request: DeleteServerRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.DeleteServerResponse.ReadOnly
            ] = proxy(DeleteServer, request)
            def exportServerEngineAttribute(
                request: ExportServerEngineAttributeRequest
            ): IO[
              AwsError,
              zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly
            ] = proxy(ExportServerEngineAttribute, request)
            def associateNode(request: AssociateNodeRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly
            ] = proxy(AssociateNode, request)
            def createBackup(request: CreateBackupRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly
            ] = proxy(CreateBackup, request)
            def describeNodeAssociationStatus(
                request: DescribeNodeAssociationStatusRequest
            ): IO[
              AwsError,
              zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly
            ] = proxy(DescribeNodeAssociationStatus, request)
            def describeBackups(request: DescribeBackupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.opsworkscm.model.Backup.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeBackups, request))
            def describeBackupsPaginated(request: DescribeBackupsRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly
            ] = proxy(DescribeBackupsPaginated, request)
            def restoreServer(request: RestoreServerRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly
            ] = proxy(RestoreServer, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def disassociateNode(request: DisassociateNodeRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly
            ] = proxy(DisassociateNode, request)
            def describeServers(request: DescribeServersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.opsworkscm.model.Server.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeServers, request))
            def describeServersPaginated(request: DescribeServersRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly
            ] = proxy(DescribeServersPaginated, request)
            def deleteBackup(request: DeleteBackupRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.DeleteBackupResponse.ReadOnly
            ] = proxy(DeleteBackup, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Tag.ReadOnly] =
              rts.unsafeRun(proxy(ListTagsForResource, request))
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.opsworkscm.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def createServer(
                request: CreateServerRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateServer, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def startMaintenance(request: StartMaintenanceRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly
            ] = proxy(StartMaintenance, request)
            def updateServerEngineAttributes(
                request: UpdateServerEngineAttributesRequest
            ): IO[
              AwsError,
              zio.aws.opsworkscm.model.UpdateServerEngineAttributesResponse.ReadOnly
            ] = proxy(UpdateServerEngineAttributes, request)
            def describeAccountAttributes(
                request: DescribeAccountAttributesRequest
            ): IO[
              AwsError,
              zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly
            ] = proxy(DescribeAccountAttributes, request)
            def describeEvents(request: DescribeEventsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.opsworkscm.model.ServerEvent.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeEvents, request))
            def describeEventsPaginated(request: DescribeEventsRequest): IO[
              AwsError,
              zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly
            ] = proxy(DescribeEventsPaginated, request)
          }
        }
      }
    }
  }
}
