package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.ServerName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportServerEngineAttributeResponse(
    engineAttribute: Optional[zio.aws.opsworkscm.model.EngineAttribute] =
      Optional.Absent,
    serverName: Optional[ServerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse = {
    import ExportServerEngineAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse
      .builder()
      .optionallyWith(engineAttribute.map(value => value.buildAwsValue()))(
        _.engineAttribute
      )
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .build()
  }
  def asReadOnly
      : zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly =
    zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse
      .wrap(buildAwsValue())
}
object ExportServerEngineAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse =
      zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse(
        engineAttribute.map(value => value.asEditable),
        serverName.map(value => value)
      )
    def engineAttribute
        : Optional[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]
    def serverName: Optional[ServerName]
    def getEngineAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("engineAttribute", engineAttribute)
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse
  ) extends zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly {
    override val engineAttribute
        : Optional[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineAttribute())
        .map(value => zio.aws.opsworkscm.model.EngineAttribute.wrap(value))
    override val serverName: Optional[ServerName] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => zio.aws.opsworkscm.model.primitives.ServerName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse
  ): zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
