package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  AttributeValue,
  AttributeName,
  ServerName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServerEngineAttributesRequest(
    serverName: ServerName,
    attributeName: AttributeName,
    attributeValue: Option[AttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest = {
    import UpdateServerEngineAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .attributeName(AttributeName.unwrap(attributeName): java.lang.String)
      .optionallyWith(
        attributeValue.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.attributeValue)
      .build()
  }
  def asReadOnly
      : zio.aws.opsworkscm.model.UpdateServerEngineAttributesRequest.ReadOnly =
    zio.aws.opsworkscm.model.UpdateServerEngineAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateServerEngineAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opsworkscm.model.UpdateServerEngineAttributesRequest =
      zio.aws.opsworkscm.model.UpdateServerEngineAttributesRequest(
        serverName,
        attributeName,
        attributeValue.map(value => value)
      )
    def serverName: ServerName
    def attributeName: AttributeName
    def attributeValue: Option[AttributeValue]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getAttributeName: ZIO[Any, Nothing, AttributeName] =
      ZIO.succeed(attributeName)
    def getAttributeValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest
  ) extends zio.aws.opsworkscm.model.UpdateServerEngineAttributesRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val attributeName: AttributeName =
      zio.aws.opsworkscm.model.primitives.AttributeName(impl.attributeName())
    override val attributeValue: Option[AttributeValue] = scala
      .Option(impl.attributeValue())
      .map(value => zio.aws.opsworkscm.model.primitives.AttributeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest
  ): zio.aws.opsworkscm.model.UpdateServerEngineAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
