package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.NodeAssociationStatusToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssociateNodeResponse(
    nodeAssociationStatusToken: Option[NodeAssociationStatusToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse = {
    import AssociateNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
      .builder()
      .optionallyWith(
        nodeAssociationStatusToken.map(value =>
          NodeAssociationStatusToken.unwrap(value): java.lang.String
        )
      )(_.nodeAssociationStatusToken)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly =
    zio.aws.opsworkscm.model.AssociateNodeResponse.wrap(buildAwsValue())
}
object AssociateNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.AssociateNodeResponse =
      zio.aws.opsworkscm.model
        .AssociateNodeResponse(nodeAssociationStatusToken.map(value => value))
    def nodeAssociationStatusToken: Option[NodeAssociationStatusToken]
    def getNodeAssociationStatusToken
        : ZIO[Any, AwsError, NodeAssociationStatusToken] =
      AwsError.unwrapOptionField(
        "nodeAssociationStatusToken",
        nodeAssociationStatusToken
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
  ) extends zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly {
    override val nodeAssociationStatusToken
        : Option[NodeAssociationStatusToken] = scala
      .Option(impl.nodeAssociationStatusToken())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.NodeAssociationStatusToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
  ): zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly = new Wrapper(impl)
}
