package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccountAttribute(
    name: Option[String] = None,
    maximum: Option[Integer] = None,
    used: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.AccountAttribute = {
    import AccountAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(maximum.map(value => value: java.lang.Integer))(_.maximum)
      .optionallyWith(used.map(value => value: java.lang.Integer))(_.used)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.AccountAttribute.ReadOnly =
    zio.aws.opsworkscm.model.AccountAttribute.wrap(buildAwsValue())
}
object AccountAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.AccountAttribute =
      zio.aws.opsworkscm.model.AccountAttribute(
        name.map(value => value),
        maximum.map(value => value),
        used.map(value => value)
      )
    def name: Option[String]
    def maximum: Option[Integer]
    def used: Option[Integer]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMaximum: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getUsed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("used", used)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
  ) extends zio.aws.opsworkscm.model.AccountAttribute.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val maximum: Option[Integer] =
      scala.Option(impl.maximum()).map(value => value: Integer)
    override val used: Option[Integer] =
      scala.Option(impl.used()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
  ): zio.aws.opsworkscm.model.AccountAttribute.ReadOnly = new Wrapper(impl)
}
