package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{TagKey, AWSOpsWorksCMResourceArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: AWSOpsWorksCMResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest
      .builder()
      .resourceArn(
        AWSOpsWorksCMResourceArn.unwrap(resourceArn): java.lang.String
      )
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.UntagResourceRequest.ReadOnly =
    zio.aws.opsworkscm.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.UntagResourceRequest =
      zio.aws.opsworkscm.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AWSOpsWorksCMResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AWSOpsWorksCMResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest
  ) extends zio.aws.opsworkscm.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AWSOpsWorksCMResourceArn =
      zio.aws.opsworkscm.model.primitives
        .AWSOpsWorksCMResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.opsworkscm.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest
  ): zio.aws.opsworkscm.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
