package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  Timestamp,
  BackupId,
  Integer,
  ServerName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Backup(
    backupArn: Option[String] = None,
    backupId: Option[BackupId] = None,
    backupType: Option[zio.aws.opsworkscm.model.BackupType] = None,
    createdAt: Option[Timestamp] = None,
    description: Option[String] = None,
    engine: Option[String] = None,
    engineModel: Option[String] = None,
    engineVersion: Option[String] = None,
    instanceProfileArn: Option[String] = None,
    instanceType: Option[String] = None,
    keyPair: Option[String] = None,
    preferredBackupWindow: Option[TimeWindowDefinition] = None,
    preferredMaintenanceWindow: Option[TimeWindowDefinition] = None,
    s3DataSize: Option[Integer] = None,
    s3DataUrl: Option[String] = None,
    s3LogUrl: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    serverName: Option[ServerName] = None,
    serviceRoleArn: Option[String] = None,
    status: Option[zio.aws.opsworkscm.model.BackupStatus] = None,
    statusDescription: Option[String] = None,
    subnetIds: Option[Iterable[String]] = None,
    toolsVersion: Option[String] = None,
    userArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.Backup = {
    import Backup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.Backup
      .builder()
      .optionallyWith(backupArn.map(value => value: java.lang.String))(
        _.backupArn
      )
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .optionallyWith(backupType.map(value => value.unwrap))(_.backupType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineModel.map(value => value: java.lang.String))(
        _.engineModel
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(instanceProfileArn.map(value => value: java.lang.String))(
        _.instanceProfileArn
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(keyPair.map(value => value: java.lang.String))(_.keyPair)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(s3DataSize.map(value => value: java.lang.Integer))(
        _.s3DataSize
      )
      .optionallyWith(s3DataUrl.map(value => value: java.lang.String))(
        _.s3DataUrl
      )
      .optionallyWith(s3LogUrl.map(value => value: java.lang.String))(
        _.s3LogUrl
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusDescription.map(value => value: java.lang.String))(
        _.statusDescription
      )
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(toolsVersion.map(value => value: java.lang.String))(
        _.toolsVersion
      )
      .optionallyWith(userArn.map(value => value: java.lang.String))(_.userArn)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.Backup.ReadOnly =
    zio.aws.opsworkscm.model.Backup.wrap(buildAwsValue())
}
object Backup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.opsworkscm.model.Backup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.Backup =
      zio.aws.opsworkscm.model.Backup(
        backupArn.map(value => value),
        backupId.map(value => value),
        backupType.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        engine.map(value => value),
        engineModel.map(value => value),
        engineVersion.map(value => value),
        instanceProfileArn.map(value => value),
        instanceType.map(value => value),
        keyPair.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        s3DataSize.map(value => value),
        s3DataUrl.map(value => value),
        s3LogUrl.map(value => value),
        securityGroupIds.map(value => value),
        serverName.map(value => value),
        serviceRoleArn.map(value => value),
        status.map(value => value),
        statusDescription.map(value => value),
        subnetIds.map(value => value),
        toolsVersion.map(value => value),
        userArn.map(value => value)
      )
    def backupArn: Option[String]
    def backupId: Option[BackupId]
    def backupType: Option[zio.aws.opsworkscm.model.BackupType]
    def createdAt: Option[Timestamp]
    def description: Option[String]
    def engine: Option[String]
    def engineModel: Option[String]
    def engineVersion: Option[String]
    def instanceProfileArn: Option[String]
    def instanceType: Option[String]
    def keyPair: Option[String]
    def preferredBackupWindow: Option[TimeWindowDefinition]
    def preferredMaintenanceWindow: Option[TimeWindowDefinition]
    def s3DataSize: Option[Integer]
    def s3DataUrl: Option[String]
    def s3LogUrl: Option[String]
    def securityGroupIds: Option[List[String]]
    def serverName: Option[ServerName]
    def serviceRoleArn: Option[String]
    def status: Option[zio.aws.opsworkscm.model.BackupStatus]
    def statusDescription: Option[String]
    def subnetIds: Option[List[String]]
    def toolsVersion: Option[String]
    def userArn: Option[String]
    def getBackupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupArn", backupArn)
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getBackupType: ZIO[Any, AwsError, zio.aws.opsworkscm.model.BackupType] =
      AwsError.unwrapOptionField("backupType", backupType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineModel", engineModel)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getInstanceProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileArn", instanceProfileArn)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyPair: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getS3DataSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("s3DataSize", s3DataSize)
    def getS3DataUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3DataUrl", s3DataUrl)
    def getS3LogUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3LogUrl", s3LogUrl)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.opsworkscm.model.BackupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusDescription", statusDescription)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getToolsVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("toolsVersion", toolsVersion)
    def getUserArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userArn", userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.Backup
  ) extends zio.aws.opsworkscm.model.Backup.ReadOnly {
    override val backupArn: Option[String] =
      scala.Option(impl.backupArn()).map(value => value: String)
    override val backupId: Option[BackupId] = scala
      .Option(impl.backupId())
      .map(value => zio.aws.opsworkscm.model.primitives.BackupId(value))
    override val backupType: Option[zio.aws.opsworkscm.model.BackupType] = scala
      .Option(impl.backupType())
      .map(value => zio.aws.opsworkscm.model.BackupType.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.opsworkscm.model.primitives.Timestamp(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineModel: Option[String] =
      scala.Option(impl.engineModel()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val instanceProfileArn: Option[String] =
      scala.Option(impl.instanceProfileArn()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val keyPair: Option[String] =
      scala.Option(impl.keyPair()).map(value => value: String)
    override val preferredBackupWindow: Option[TimeWindowDefinition] = scala
      .Option(impl.preferredBackupWindow())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
      )
    override val preferredMaintenanceWindow: Option[TimeWindowDefinition] =
      scala
        .Option(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val s3DataSize: Option[Integer] =
      scala.Option(impl.s3DataSize()).map(value => value: Integer)
    override val s3DataUrl: Option[String] =
      scala.Option(impl.s3DataUrl()).map(value => value: String)
    override val s3LogUrl: Option[String] =
      scala.Option(impl.s3LogUrl()).map(value => value: String)
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serverName: Option[ServerName] = scala
      .Option(impl.serverName())
      .map(value => zio.aws.opsworkscm.model.primitives.ServerName(value))
    override val serviceRoleArn: Option[String] =
      scala.Option(impl.serviceRoleArn()).map(value => value: String)
    override val status: Option[zio.aws.opsworkscm.model.BackupStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.opsworkscm.model.BackupStatus.wrap(value))
    override val statusDescription: Option[String] =
      scala.Option(impl.statusDescription()).map(value => value: String)
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val toolsVersion: Option[String] =
      scala.Option(impl.toolsVersion()).map(value => value: String)
    override val userArn: Option[String] =
      scala.Option(impl.userArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.Backup
  ): zio.aws.opsworkscm.model.Backup.ReadOnly = new Wrapper(impl)
}
