package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServerResponse(
    server: Option[zio.aws.opsworkscm.model.Server] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse = {
    import UpdateServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly =
    zio.aws.opsworkscm.model.UpdateServerResponse.wrap(buildAwsValue())
}
object UpdateServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.UpdateServerResponse =
      zio.aws.opsworkscm.model
        .UpdateServerResponse(server.map(value => value.asEditable))
    def server: Option[zio.aws.opsworkscm.model.Server.ReadOnly]
    def getServer
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse
  ) extends zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly {
    override val server: Option[zio.aws.opsworkscm.model.Server.ReadOnly] =
      scala
        .Option(impl.server())
        .map(value => zio.aws.opsworkscm.model.Server.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse
  ): zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly = new Wrapper(impl)
}
