package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAttributesResponse(
    attributes: Option[Iterable[zio.aws.opsworkscm.model.AccountAttribute]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse = {
    import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly =
    zio.aws.opsworkscm.model.DescribeAccountAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeAccountAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeAccountAttributesResponse =
      zio.aws.opsworkscm.model.DescribeAccountAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes
        : Option[List[zio.aws.opsworkscm.model.AccountAttribute.ReadOnly]]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.AccountAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse
  ) extends zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly {
    override val attributes
        : Option[List[zio.aws.opsworkscm.model.AccountAttribute.ReadOnly]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.AccountAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse
  ): zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
