package zio.aws.opsworkscm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  BackupRetentionCountDefinition,
  BackupId,
  ServiceRoleArn,
  CustomPrivateKey,
  ServerName,
  InstanceProfileArn,
  KeyPair,
  CustomDomain,
  CustomCertificate
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateServerRequest(
    associatePublicIpAddress: Option[Boolean] = None,
    customDomain: Option[CustomDomain] = None,
    customCertificate: Option[CustomCertificate] = None,
    customPrivateKey: Option[CustomPrivateKey] = None,
    disableAutomatedBackup: Option[Boolean] = None,
    engine: String,
    engineModel: Option[String] = None,
    engineVersion: Option[String] = None,
    engineAttributes: Option[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = None,
    backupRetentionCount: Option[BackupRetentionCountDefinition] = None,
    serverName: ServerName,
    instanceProfileArn: InstanceProfileArn,
    instanceType: String,
    keyPair: Option[KeyPair] = None,
    preferredMaintenanceWindow: Option[TimeWindowDefinition] = None,
    preferredBackupWindow: Option[TimeWindowDefinition] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    serviceRoleArn: ServiceRoleArn,
    subnetIds: Option[Iterable[String]] = None,
    tags: Option[Iterable[zio.aws.opsworkscm.model.Tag]] = None,
    backupId: Option[BackupId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest = {
    import CreateServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        customDomain.map(value => CustomDomain.unwrap(value): java.lang.String)
      )(_.customDomain)
      .optionallyWith(
        customCertificate.map(value =>
          CustomCertificate.unwrap(value): java.lang.String
        )
      )(_.customCertificate)
      .optionallyWith(
        customPrivateKey.map(value =>
          CustomPrivateKey.unwrap(value): java.lang.String
        )
      )(_.customPrivateKey)
      .optionallyWith(
        disableAutomatedBackup.map(value => value: java.lang.Boolean)
      )(_.disableAutomatedBackup)
      .engine(engine: java.lang.String)
      .optionallyWith(engineModel.map(value => value: java.lang.String))(
        _.engineModel
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .optionallyWith(
        backupRetentionCount.map(value =>
          BackupRetentionCountDefinition.unwrap(value): Integer
        )
      )(_.backupRetentionCount)
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .instanceProfileArn(
        InstanceProfileArn.unwrap(instanceProfileArn): java.lang.String
      )
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(
        keyPair.map(value => KeyPair.unwrap(value): java.lang.String)
      )(_.keyPair)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .serviceRoleArn(ServiceRoleArn.unwrap(serviceRoleArn): java.lang.String)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.CreateServerRequest.ReadOnly =
    zio.aws.opsworkscm.model.CreateServerRequest.wrap(buildAwsValue())
}
object CreateServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.CreateServerRequest =
      zio.aws.opsworkscm.model.CreateServerRequest(
        associatePublicIpAddress.map(value => value),
        customDomain.map(value => value),
        customCertificate.map(value => value),
        customPrivateKey.map(value => value),
        disableAutomatedBackup.map(value => value),
        engine,
        engineModel.map(value => value),
        engineVersion.map(value => value),
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupRetentionCount.map(value => value),
        serverName,
        instanceProfileArn,
        instanceType,
        keyPair.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        preferredBackupWindow.map(value => value),
        securityGroupIds.map(value => value),
        serviceRoleArn,
        subnetIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupId.map(value => value)
      )
    def associatePublicIpAddress: Option[Boolean]
    def customDomain: Option[CustomDomain]
    def customCertificate: Option[CustomCertificate]
    def customPrivateKey: Option[CustomPrivateKey]
    def disableAutomatedBackup: Option[Boolean]
    def engine: String
    def engineModel: Option[String]
    def engineVersion: Option[String]
    def engineAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def backupRetentionCount: Option[BackupRetentionCountDefinition]
    def serverName: ServerName
    def instanceProfileArn: InstanceProfileArn
    def instanceType: String
    def keyPair: Option[KeyPair]
    def preferredMaintenanceWindow: Option[TimeWindowDefinition]
    def preferredBackupWindow: Option[TimeWindowDefinition]
    def securityGroupIds: Option[List[String]]
    def serviceRoleArn: ServiceRoleArn
    def subnetIds: Option[List[String]]
    def tags: Option[List[zio.aws.opsworkscm.model.Tag.ReadOnly]]
    def backupId: Option[BackupId]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getCustomDomain: ZIO[Any, AwsError, CustomDomain] =
      AwsError.unwrapOptionField("customDomain", customDomain)
    def getCustomCertificate: ZIO[Any, AwsError, CustomCertificate] =
      AwsError.unwrapOptionField("customCertificate", customCertificate)
    def getCustomPrivateKey: ZIO[Any, AwsError, CustomPrivateKey] =
      AwsError.unwrapOptionField("customPrivateKey", customPrivateKey)
    def getDisableAutomatedBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableAutomatedBackup", disableAutomatedBackup)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineModel", engineModel)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
    def getBackupRetentionCount
        : ZIO[Any, AwsError, BackupRetentionCountDefinition] =
      AwsError.unwrapOptionField("backupRetentionCount", backupRetentionCount)
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getInstanceProfileArn: ZIO[Any, Nothing, InstanceProfileArn] =
      ZIO.succeed(instanceProfileArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getKeyPair: ZIO[Any, AwsError, KeyPair] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServiceRoleArn: ZIO[Any, Nothing, ServiceRoleArn] =
      ZIO.succeed(serviceRoleArn)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
  ) extends zio.aws.opsworkscm.model.CreateServerRequest.ReadOnly {
    override val associatePublicIpAddress: Option[Boolean] =
      scala.Option(impl.associatePublicIpAddress()).map(value => value: Boolean)
    override val customDomain: Option[CustomDomain] = scala
      .Option(impl.customDomain())
      .map(value => zio.aws.opsworkscm.model.primitives.CustomDomain(value))
    override val customCertificate: Option[CustomCertificate] = scala
      .Option(impl.customCertificate())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.CustomCertificate(value)
      )
    override val customPrivateKey: Option[CustomPrivateKey] = scala
      .Option(impl.customPrivateKey())
      .map(value => zio.aws.opsworkscm.model.primitives.CustomPrivateKey(value))
    override val disableAutomatedBackup: Option[Boolean] =
      scala.Option(impl.disableAutomatedBackup()).map(value => value: Boolean)
    override val engine: String = impl.engine(): String
    override val engineModel: Option[String] =
      scala.Option(impl.engineModel()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val engineAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      scala
        .Option(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
    override val backupRetentionCount: Option[BackupRetentionCountDefinition] =
      scala
        .Option(impl.backupRetentionCount())
        .map(value =>
          zio.aws.opsworkscm.model.primitives
            .BackupRetentionCountDefinition(value)
        )
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val instanceProfileArn: InstanceProfileArn =
      zio.aws.opsworkscm.model.primitives
        .InstanceProfileArn(impl.instanceProfileArn())
    override val instanceType: String = impl.instanceType(): String
    override val keyPair: Option[KeyPair] = scala
      .Option(impl.keyPair())
      .map(value => zio.aws.opsworkscm.model.primitives.KeyPair(value))
    override val preferredMaintenanceWindow: Option[TimeWindowDefinition] =
      scala
        .Option(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val preferredBackupWindow: Option[TimeWindowDefinition] = scala
      .Option(impl.preferredBackupWindow())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceRoleArn: ServiceRoleArn =
      zio.aws.opsworkscm.model.primitives.ServiceRoleArn(impl.serviceRoleArn())
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.Tag.wrap(item)
          }.toList
        )
    override val backupId: Option[BackupId] = scala
      .Option(impl.backupId())
      .map(value => zio.aws.opsworkscm.model.primitives.BackupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
  ): zio.aws.opsworkscm.model.CreateServerRequest.ReadOnly = new Wrapper(impl)
}
