package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.ServerName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartMaintenanceRequest(
    serverName: ServerName,
    engineAttributes: Option[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest = {
    import StartMaintenanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.StartMaintenanceRequest.ReadOnly =
    zio.aws.opsworkscm.model.StartMaintenanceRequest.wrap(buildAwsValue())
}
object StartMaintenanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.StartMaintenanceRequest =
      zio.aws.opsworkscm.model.StartMaintenanceRequest(
        serverName,
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverName: ServerName
    def engineAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest
  ) extends zio.aws.opsworkscm.model.StartMaintenanceRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val engineAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      scala
        .Option(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest
  ): zio.aws.opsworkscm.model.StartMaintenanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
