package zio.aws.opsworkscm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  MaxResults,
  NextToken,
  ServerName,
  BackupId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeBackupsRequest(
    backupId: Option[BackupId] = None,
    serverName: Option[ServerName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest = {
    import DescribeBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
      .builder()
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeBackupsRequest.ReadOnly =
    zio.aws.opsworkscm.model.DescribeBackupsRequest.wrap(buildAwsValue())
}
object DescribeBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeBackupsRequest =
      zio.aws.opsworkscm.model.DescribeBackupsRequest(
        backupId.map(value => value),
        serverName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def backupId: Option[BackupId]
    def serverName: Option[ServerName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
  ) extends zio.aws.opsworkscm.model.DescribeBackupsRequest.ReadOnly {
    override val backupId: Option[BackupId] = scala
      .Option(impl.backupId())
      .map(value => zio.aws.opsworkscm.model.primitives.BackupId(value))
    override val serverName: Option[ServerName] = scala
      .Option(impl.serverName())
      .map(value => zio.aws.opsworkscm.model.primitives.ServerName(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.opsworkscm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.opsworkscm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
  ): zio.aws.opsworkscm.model.DescribeBackupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
