package zio.aws.opsworkscm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  MaxResults,
  NextToken,
  AWSOpsWorksCMResourceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceArn: AWSOpsWorksCMResourceArn,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(
        AWSOpsWorksCMResourceArn.unwrap(resourceArn): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.opsworkscm.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.ListTagsForResourceRequest =
      zio.aws.opsworkscm.model.ListTagsForResourceRequest(
        resourceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: AWSOpsWorksCMResourceArn
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getResourceArn: ZIO[Any, Nothing, AWSOpsWorksCMResourceArn] =
      ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest
  ) extends zio.aws.opsworkscm.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AWSOpsWorksCMResourceArn =
      zio.aws.opsworkscm.model.primitives
        .AWSOpsWorksCMResourceArn(impl.resourceArn())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.opsworkscm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.opsworkscm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest
  ): zio.aws.opsworkscm.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
