package zio.aws.opsworkscm.model
import scala.jdk.CollectionConverters.*
sealed trait ServerStatus {
  def unwrap: software.amazon.awssdk.services.opsworkscm.model.ServerStatus
}
object ServerStatus {
  def wrap(
      value: software.amazon.awssdk.services.opsworkscm.model.ServerStatus
  ): zio.aws.opsworkscm.model.ServerStatus = value match {
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.BACKING_UP =>
      val r = BACKING_UP
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.CONNECTION_LOST =>
      val r = CONNECTION_LOST
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.MODIFYING =>
      val r = MODIFYING
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.RESTORING =>
      val r = RESTORING
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.SETUP =>
      val r = SETUP
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.UNDER_MAINTENANCE =>
      val r = UNDER_MAINTENANCE
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.opsworkscm.model.ServerStatus.TERMINATED =>
      val r = TERMINATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object BACKING_UP extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.BACKING_UP
  }
  case object CONNECTION_LOST extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.CONNECTION_LOST
  }
  case object CREATING extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.CREATING
  }
  case object DELETING extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.DELETING
  }
  case object MODIFYING extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.MODIFYING
  }
  case object FAILED extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.FAILED
  }
  case object HEALTHY extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.HEALTHY
  }
  case object RUNNING extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.RUNNING
  }
  case object RESTORING extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.RESTORING
  }
  case object SETUP extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.SETUP
  }
  case object UNDER_MAINTENANCE extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.UNDER_MAINTENANCE
  }
  case object UNHEALTHY extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.UNHEALTHY
  }
  case object TERMINATED extends zio.aws.opsworkscm.model.ServerStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.ServerStatus =
      software.amazon.awssdk.services.opsworkscm.model.ServerStatus.TERMINATED
  }
}
