package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEventsResponse(
    serverEvents: Option[Iterable[zio.aws.opsworkscm.model.ServerEvent]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse
      .builder()
      .optionallyWith(
        serverEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverEvents)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly =
    zio.aws.opsworkscm.model.DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeEventsResponse =
      zio.aws.opsworkscm.model.DescribeEventsResponse(
        serverEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def serverEvents
        : Option[List[zio.aws.opsworkscm.model.ServerEvent.ReadOnly]]
    def nextToken: Option[String]
    def getServerEvents: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.ServerEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("serverEvents", serverEvents)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse
  ) extends zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly {
    override val serverEvents
        : Option[List[zio.aws.opsworkscm.model.ServerEvent.ReadOnly]] = scala
      .Option(impl.serverEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opsworkscm.model.ServerEvent.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse
  ): zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly = new Wrapper(
    impl
  )
}
