package zio.aws.opsworkscm.model
import scala.jdk.CollectionConverters._
sealed trait NodeAssociationStatus {
  def unwrap
      : software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus
}
object NodeAssociationStatus {
  def wrap(
      value: software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus
  ): zio.aws.opsworkscm.model.NodeAssociationStatus = value match {
    case software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opsworkscm.model.NodeAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus =
      software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.opsworkscm.model.NodeAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus =
      software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.SUCCESS
  }
  case object FAILED extends zio.aws.opsworkscm.model.NodeAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus =
      software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.FAILED
  }
  case object IN_PROGRESS
      extends zio.aws.opsworkscm.model.NodeAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus =
      software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus.IN_PROGRESS
  }
}
