package zio.aws.opsworkscm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.opsworkscm.model.primitives.{
  MaxResults,
  NextToken,
  ServerName,
  BackupId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeBackupsRequest(
    backupId: Optional[BackupId] = Optional.Absent,
    serverName: Optional[ServerName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest = {
    import DescribeBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
      .builder()
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeBackupsRequest.ReadOnly =
    zio.aws.opsworkscm.model.DescribeBackupsRequest.wrap(buildAwsValue())
}
object DescribeBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeBackupsRequest =
      zio.aws.opsworkscm.model.DescribeBackupsRequest(
        backupId.map(value => value),
        serverName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def backupId: Optional[BackupId]
    def serverName: Optional[ServerName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
  ) extends zio.aws.opsworkscm.model.DescribeBackupsRequest.ReadOnly {
    override val backupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.backupId())
      .map(value => zio.aws.opsworkscm.model.primitives.BackupId(value))
    override val serverName: Optional[ServerName] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => zio.aws.opsworkscm.model.primitives.ServerName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opsworkscm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.opsworkscm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest
  ): zio.aws.opsworkscm.model.DescribeBackupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
