package zio.aws.opsworkscm.model
import scala.jdk.CollectionConverters._
sealed trait BackupType {
  def unwrap: software.amazon.awssdk.services.opsworkscm.model.BackupType
}
object BackupType {
  def wrap(
      value: software.amazon.awssdk.services.opsworkscm.model.BackupType
  ): zio.aws.opsworkscm.model.BackupType = value match {
    case software.amazon.awssdk.services.opsworkscm.model.BackupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opsworkscm.model.BackupType.AUTOMATED =>
      val r = AUTOMATED
      r
    case software.amazon.awssdk.services.opsworkscm.model.BackupType.MANUAL =>
      val r = MANUAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.opsworkscm.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupType =
      software.amazon.awssdk.services.opsworkscm.model.BackupType.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATED extends zio.aws.opsworkscm.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupType =
      software.amazon.awssdk.services.opsworkscm.model.BackupType.AUTOMATED
  }
  case object MANUAL extends zio.aws.opsworkscm.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupType =
      software.amazon.awssdk.services.opsworkscm.model.BackupType.MANUAL
  }
}
