package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  ServerName,
  NodeAssociationStatusToken
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeNodeAssociationStatusRequest(
    nodeAssociationStatusToken: NodeAssociationStatusToken,
    serverName: ServerName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest = {
    import DescribeNodeAssociationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest
      .builder()
      .nodeAssociationStatusToken(
        NodeAssociationStatusToken.unwrap(
          nodeAssociationStatusToken
        ): java.lang.String
      )
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opsworkscm.model.DescribeNodeAssociationStatusRequest.ReadOnly =
    zio.aws.opsworkscm.model.DescribeNodeAssociationStatusRequest
      .wrap(buildAwsValue())
}
object DescribeNodeAssociationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opsworkscm.model.DescribeNodeAssociationStatusRequest =
      zio.aws.opsworkscm.model.DescribeNodeAssociationStatusRequest(
        nodeAssociationStatusToken,
        serverName
      )
    def nodeAssociationStatusToken: NodeAssociationStatusToken
    def serverName: ServerName
    def getNodeAssociationStatusToken
        : ZIO[Any, Nothing, NodeAssociationStatusToken] =
      ZIO.succeed(nodeAssociationStatusToken)
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest
  ) extends zio.aws.opsworkscm.model.DescribeNodeAssociationStatusRequest.ReadOnly {
    override val nodeAssociationStatusToken: NodeAssociationStatusToken =
      zio.aws.opsworkscm.model.primitives
        .NodeAssociationStatusToken(impl.nodeAssociationStatusToken())
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest
  ): zio.aws.opsworkscm.model.DescribeNodeAssociationStatusRequest.ReadOnly =
    new Wrapper(impl)
}
