package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.BackupId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBackupRequest(backupId: BackupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest = {
    import DeleteBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DeleteBackupRequest.ReadOnly =
    zio.aws.opsworkscm.model.DeleteBackupRequest.wrap(buildAwsValue())
}
object DeleteBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DeleteBackupRequest =
      zio.aws.opsworkscm.model.DeleteBackupRequest(backupId)
    def backupId: BackupId
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest
  ) extends zio.aws.opsworkscm.model.DeleteBackupRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.opsworkscm.model.primitives.BackupId(impl.backupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest
  ): zio.aws.opsworkscm.model.DeleteBackupRequest.ReadOnly = new Wrapper(impl)
}
