package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{NodeName, ServerName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateNodeRequest(
    serverName: ServerName,
    nodeName: NodeName,
    engineAttributes: Optional[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest = {
    import DisassociateNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .nodeName(NodeName.unwrap(nodeName): java.lang.String)
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DisassociateNodeRequest.ReadOnly =
    zio.aws.opsworkscm.model.DisassociateNodeRequest.wrap(buildAwsValue())
}
object DisassociateNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DisassociateNodeRequest =
      zio.aws.opsworkscm.model.DisassociateNodeRequest(
        serverName,
        nodeName,
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverName: ServerName
    def nodeName: NodeName
    def engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getNodeName: ZIO[Any, Nothing, NodeName] = ZIO.succeed(nodeName)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest
  ) extends zio.aws.opsworkscm.model.DisassociateNodeRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val nodeName: NodeName =
      zio.aws.opsworkscm.model.primitives.NodeName(impl.nodeName())
    override val engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest
  ): zio.aws.opsworkscm.model.DisassociateNodeRequest.ReadOnly = new Wrapper(
    impl
  )
}
