package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.AWSOpsWorksCMResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AWSOpsWorksCMResourceArn,
    tags: Iterable[zio.aws.opsworkscm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest
      .builder()
      .resourceArn(
        AWSOpsWorksCMResourceArn.unwrap(resourceArn): java.lang.String
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.TagResourceRequest.ReadOnly =
    zio.aws.opsworkscm.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.TagResourceRequest =
      zio.aws.opsworkscm.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AWSOpsWorksCMResourceArn
    def tags: List[zio.aws.opsworkscm.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AWSOpsWorksCMResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest
  ) extends zio.aws.opsworkscm.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AWSOpsWorksCMResourceArn =
      zio.aws.opsworkscm.model.primitives
        .AWSOpsWorksCMResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.opsworkscm.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.opsworkscm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest
  ): zio.aws.opsworkscm.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
