package zio.aws.opsworkscm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.opsworkscm.model.primitives.Timestamp
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ServerEvent(
    createdAt: Optional[Timestamp] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    logUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.ServerEvent = {
    import ServerEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.ServerEvent
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(logUrl.map(value => value: java.lang.String))(_.logUrl)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.ServerEvent.ReadOnly =
    zio.aws.opsworkscm.model.ServerEvent.wrap(buildAwsValue())
}
object ServerEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.ServerEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.ServerEvent =
      zio.aws.opsworkscm.model.ServerEvent(
        createdAt.map(value => value),
        serverName.map(value => value),
        message.map(value => value),
        logUrl.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def serverName: Optional[String]
    def message: Optional[String]
    def logUrl: Optional[String]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getLogUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logUrl", logUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.ServerEvent
  ) extends zio.aws.opsworkscm.model.ServerEvent.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.opsworkscm.model.primitives.Timestamp(value))
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val logUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.ServerEvent
  ): zio.aws.opsworkscm.model.ServerEvent.ReadOnly = new Wrapper(impl)
}
