package zio.aws.opsworkscm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  CustomDomain,
  Timestamp,
  Integer
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Server(
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    backupRetentionCount: Optional[Integer] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    cloudFormationStackArn: Optional[String] = Optional.Absent,
    customDomain: Optional[CustomDomain] = Optional.Absent,
    disableAutomatedBackup: Optional[Boolean] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineModel: Optional[String] = Optional.Absent,
    engineAttributes: Optional[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    instanceProfileArn: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    keyPair: Optional[String] = Optional.Absent,
    maintenanceStatus: Optional[zio.aws.opsworkscm.model.MaintenanceStatus] =
      Optional.Absent,
    preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      Optional.Absent,
    preferredBackupWindow: Optional[TimeWindowDefinition] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    serviceRoleArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.opsworkscm.model.ServerStatus] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    serverArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.Server = {
    import Server.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.Server
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        backupRetentionCount.map(value => value: java.lang.Integer)
      )(_.backupRetentionCount)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        cloudFormationStackArn.map(value => value: java.lang.String)
      )(_.cloudFormationStackArn)
      .optionallyWith(
        customDomain.map(value => CustomDomain.unwrap(value): java.lang.String)
      )(_.customDomain)
      .optionallyWith(
        disableAutomatedBackup.map(value => value: java.lang.Boolean)
      )(_.disableAutomatedBackup)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineModel.map(value => value: java.lang.String))(
        _.engineModel
      )
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(instanceProfileArn.map(value => value: java.lang.String))(
        _.instanceProfileArn
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(keyPair.map(value => value: java.lang.String))(_.keyPair)
      .optionallyWith(maintenanceStatus.map(value => value.unwrap))(
        _.maintenanceStatus
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(serverArn.map(value => value: java.lang.String))(
        _.serverArn
      )
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.Server.ReadOnly =
    zio.aws.opsworkscm.model.Server.wrap(buildAwsValue())
}
object Server {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.opsworkscm.model.Server] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.Server =
      zio.aws.opsworkscm.model.Server(
        associatePublicIpAddress.map(value => value),
        backupRetentionCount.map(value => value),
        serverName.map(value => value),
        createdAt.map(value => value),
        cloudFormationStackArn.map(value => value),
        customDomain.map(value => value),
        disableAutomatedBackup.map(value => value),
        endpoint.map(value => value),
        engine.map(value => value),
        engineModel.map(value => value),
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        engineVersion.map(value => value),
        instanceProfileArn.map(value => value),
        instanceType.map(value => value),
        keyPair.map(value => value),
        maintenanceStatus.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        preferredBackupWindow.map(value => value),
        securityGroupIds.map(value => value),
        serviceRoleArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        subnetIds.map(value => value),
        serverArn.map(value => value)
      )
    def associatePublicIpAddress: Optional[Boolean]
    def backupRetentionCount: Optional[Integer]
    def serverName: Optional[String]
    def createdAt: Optional[Timestamp]
    def cloudFormationStackArn: Optional[String]
    def customDomain: Optional[CustomDomain]
    def disableAutomatedBackup: Optional[Boolean]
    def endpoint: Optional[String]
    def engine: Optional[String]
    def engineModel: Optional[String]
    def engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def engineVersion: Optional[String]
    def instanceProfileArn: Optional[String]
    def instanceType: Optional[String]
    def keyPair: Optional[String]
    def maintenanceStatus: Optional[zio.aws.opsworkscm.model.MaintenanceStatus]
    def preferredMaintenanceWindow: Optional[TimeWindowDefinition]
    def preferredBackupWindow: Optional[TimeWindowDefinition]
    def securityGroupIds: Optional[List[String]]
    def serviceRoleArn: Optional[String]
    def status: Optional[zio.aws.opsworkscm.model.ServerStatus]
    def statusReason: Optional[String]
    def subnetIds: Optional[List[String]]
    def serverArn: Optional[String]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getBackupRetentionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionCount", backupRetentionCount)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCloudFormationStackArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cloudFormationStackArn", cloudFormationStackArn)
    def getCustomDomain: ZIO[Any, AwsError, CustomDomain] =
      AwsError.unwrapOptionField("customDomain", customDomain)
    def getDisableAutomatedBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableAutomatedBackup", disableAutomatedBackup)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineModel", engineModel)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getInstanceProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileArn", instanceProfileArn)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyPair: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getMaintenanceStatus
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.MaintenanceStatus] =
      AwsError.unwrapOptionField("maintenanceStatus", maintenanceStatus)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.opsworkscm.model.ServerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getServerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverArn", serverArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.Server
  ) extends zio.aws.opsworkscm.model.Server.ReadOnly {
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val backupRetentionCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.backupRetentionCount())
      .map(value => value: Integer)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.opsworkscm.model.primitives.Timestamp(value))
    override val cloudFormationStackArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudFormationStackArn())
        .map(value => value: String)
    override val customDomain: Optional[CustomDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomain())
      .map(value => zio.aws.opsworkscm.model.primitives.CustomDomain(value))
    override val disableAutomatedBackup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableAutomatedBackup())
        .map(value => value: Boolean)
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineModel())
      .map(value => value: String)
    override val engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val instanceProfileArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfileArn())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val keyPair: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPair())
      .map(value => value: String)
    override val maintenanceStatus
        : Optional[zio.aws.opsworkscm.model.MaintenanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceStatus())
        .map(value => zio.aws.opsworkscm.model.MaintenanceStatus.wrap(value))
    override val preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val preferredBackupWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val serviceRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => value: String)
    override val status: Optional[zio.aws.opsworkscm.model.ServerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opsworkscm.model.ServerStatus.wrap(value))
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serverArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.Server
  ): zio.aws.opsworkscm.model.Server.ReadOnly = new Wrapper(impl)
}
