package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNodeAssociationStatusResponse(
    nodeAssociationStatus: Optional[
      zio.aws.opsworkscm.model.NodeAssociationStatus
    ] = Optional.Absent,
    engineAttributes: Optional[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse = {
    import DescribeNodeAssociationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
      .builder()
      .optionallyWith(nodeAssociationStatus.map(value => value.unwrap))(
        _.nodeAssociationStatus
      )
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly =
    zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse
      .wrap(buildAwsValue())
}
object DescribeNodeAssociationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse =
      zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse(
        nodeAssociationStatus.map(value => value),
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nodeAssociationStatus
        : Optional[zio.aws.opsworkscm.model.NodeAssociationStatus]
    def engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def getNodeAssociationStatus
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.NodeAssociationStatus] =
      AwsError.unwrapOptionField("nodeAssociationStatus", nodeAssociationStatus)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
  ) extends zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly {
    override val nodeAssociationStatus
        : Optional[zio.aws.opsworkscm.model.NodeAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeAssociationStatus())
        .map(value =>
          zio.aws.opsworkscm.model.NodeAssociationStatus.wrap(value)
        )
    override val engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
  ): zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
