package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.NodeAssociationStatusToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateNodeResponse(
    nodeAssociationStatusToken: Optional[NodeAssociationStatusToken] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse = {
    import AssociateNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
      .builder()
      .optionallyWith(
        nodeAssociationStatusToken.map(value =>
          NodeAssociationStatusToken.unwrap(value): java.lang.String
        )
      )(_.nodeAssociationStatusToken)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly =
    zio.aws.opsworkscm.model.AssociateNodeResponse.wrap(buildAwsValue())
}
object AssociateNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.AssociateNodeResponse =
      zio.aws.opsworkscm.model
        .AssociateNodeResponse(nodeAssociationStatusToken.map(value => value))
    def nodeAssociationStatusToken: Optional[NodeAssociationStatusToken]
    def getNodeAssociationStatusToken
        : ZIO[Any, AwsError, NodeAssociationStatusToken] =
      AwsError.unwrapOptionField(
        "nodeAssociationStatusToken",
        nodeAssociationStatusToken
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
  ) extends zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly {
    override val nodeAssociationStatusToken
        : Optional[NodeAssociationStatusToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeAssociationStatusToken())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.NodeAssociationStatusToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse
  ): zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly = new Wrapper(impl)
}
