package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.ServerName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportServerEngineAttributeRequest(
    exportAttributeName: String,
    serverName: ServerName,
    inputAttributes: Option[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest = {
    import ExportServerEngineAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest
      .builder()
      .exportAttributeName(exportAttributeName: java.lang.String)
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(
        inputAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.opsworkscm.model.ExportServerEngineAttributeRequest.ReadOnly =
    zio.aws.opsworkscm.model.ExportServerEngineAttributeRequest
      .wrap(buildAwsValue())
}
object ExportServerEngineAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opsworkscm.model.ExportServerEngineAttributeRequest =
      zio.aws.opsworkscm.model.ExportServerEngineAttributeRequest(
        exportAttributeName,
        serverName,
        inputAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def exportAttributeName: String
    def serverName: ServerName
    def inputAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def getExportAttributeName: ZIO[Any, Nothing, String] =
      ZIO.succeed(exportAttributeName)
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getInputAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("inputAttributes", inputAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest
  ) extends zio.aws.opsworkscm.model.ExportServerEngineAttributeRequest.ReadOnly {
    override val exportAttributeName: String =
      impl.exportAttributeName(): String
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val inputAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      scala
        .Option(impl.inputAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest
  ): zio.aws.opsworkscm.model.ExportServerEngineAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
