package zio.aws.opsworkscm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{MaxResults, NextToken, ServerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventsRequest(
    serverName: ServerName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeEventsRequest.ReadOnly =
    zio.aws.opsworkscm.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeEventsRequest =
      zio.aws.opsworkscm.model.DescribeEventsRequest(
        serverName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serverName: ServerName
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
  ) extends zio.aws.opsworkscm.model.DescribeEventsRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.opsworkscm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.opsworkscm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
  ): zio.aws.opsworkscm.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
