package zio.aws.opsworkscm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{MaxResults, NextToken, ServerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeServersRequest(
    serverName: Option[ServerName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest = {
    import DescribeServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest
      .builder()
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeServersRequest.ReadOnly =
    zio.aws.opsworkscm.model.DescribeServersRequest.wrap(buildAwsValue())
}
object DescribeServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeServersRequest =
      zio.aws.opsworkscm.model.DescribeServersRequest(
        serverName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serverName: Option[ServerName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest
  ) extends zio.aws.opsworkscm.model.DescribeServersRequest.ReadOnly {
    override val serverName: Option[ServerName] = scala
      .Option(impl.serverName())
      .map(value => zio.aws.opsworkscm.model.primitives.ServerName(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.opsworkscm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.opsworkscm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest
  ): zio.aws.opsworkscm.model.DescribeServersRequest.ReadOnly = new Wrapper(
    impl
  )
}
