package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ServerEvent(
    createdAt: Option[Timestamp] = None,
    serverName: Option[String] = None,
    message: Option[String] = None,
    logUrl: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.ServerEvent = {
    import ServerEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.ServerEvent
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(logUrl.map(value => value: java.lang.String))(_.logUrl)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.ServerEvent.ReadOnly =
    zio.aws.opsworkscm.model.ServerEvent.wrap(buildAwsValue())
}
object ServerEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.ServerEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.ServerEvent =
      zio.aws.opsworkscm.model.ServerEvent(
        createdAt.map(value => value),
        serverName.map(value => value),
        message.map(value => value),
        logUrl.map(value => value)
      )
    def createdAt: Option[Timestamp]
    def serverName: Option[String]
    def message: Option[String]
    def logUrl: Option[String]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getLogUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logUrl", logUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.ServerEvent
  ) extends zio.aws.opsworkscm.model.ServerEvent.ReadOnly {
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.opsworkscm.model.primitives.Timestamp(value))
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val logUrl: Option[String] =
      scala.Option(impl.logUrl()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.ServerEvent
  ): zio.aws.opsworkscm.model.ServerEvent.ReadOnly = new Wrapper(impl)
}
