package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBackupResponse(
    backup: Option[zio.aws.opsworkscm.model.Backup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse = {
    import CreateBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse
      .builder()
      .optionallyWith(backup.map(value => value.buildAwsValue()))(_.backup)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly =
    zio.aws.opsworkscm.model.CreateBackupResponse.wrap(buildAwsValue())
}
object CreateBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.CreateBackupResponse =
      zio.aws.opsworkscm.model
        .CreateBackupResponse(backup.map(value => value.asEditable))
    def backup: Option[zio.aws.opsworkscm.model.Backup.ReadOnly]
    def getBackup
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.Backup.ReadOnly] =
      AwsError.unwrapOptionField("backup", backup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse
  ) extends zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly {
    override val backup: Option[zio.aws.opsworkscm.model.Backup.ReadOnly] =
      scala
        .Option(impl.backup())
        .map(value => zio.aws.opsworkscm.model.Backup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse
  ): zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly = new Wrapper(impl)
}
