package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.ServerName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBackupRequest(
    serverName: ServerName,
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.opsworkscm.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest = {
    import CreateBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.CreateBackupRequest.ReadOnly =
    zio.aws.opsworkscm.model.CreateBackupRequest.wrap(buildAwsValue())
}
object CreateBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.CreateBackupRequest =
      zio.aws.opsworkscm.model.CreateBackupRequest(
        serverName,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverName: ServerName
    def description: Option[String]
    def tags: Option[List[zio.aws.opsworkscm.model.Tag.ReadOnly]]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
  ) extends zio.aws.opsworkscm.model.CreateBackupRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
  ): zio.aws.opsworkscm.model.CreateBackupRequest.ReadOnly = new Wrapper(impl)
}
