package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  CustomDomain,
  Timestamp,
  Integer
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Server(
    associatePublicIpAddress: Option[Boolean] = None,
    backupRetentionCount: Option[Integer] = None,
    serverName: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    cloudFormationStackArn: Option[String] = None,
    customDomain: Option[CustomDomain] = None,
    disableAutomatedBackup: Option[Boolean] = None,
    endpoint: Option[String] = None,
    engine: Option[String] = None,
    engineModel: Option[String] = None,
    engineAttributes: Option[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = None,
    engineVersion: Option[String] = None,
    instanceProfileArn: Option[String] = None,
    instanceType: Option[String] = None,
    keyPair: Option[String] = None,
    maintenanceStatus: Option[zio.aws.opsworkscm.model.MaintenanceStatus] =
      None,
    preferredMaintenanceWindow: Option[TimeWindowDefinition] = None,
    preferredBackupWindow: Option[TimeWindowDefinition] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    serviceRoleArn: Option[String] = None,
    status: Option[zio.aws.opsworkscm.model.ServerStatus] = None,
    statusReason: Option[String] = None,
    subnetIds: Option[Iterable[String]] = None,
    serverArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.Server = {
    import Server.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.Server
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        backupRetentionCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.backupRetentionCount)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        cloudFormationStackArn.map(value => value: java.lang.String)
      )(_.cloudFormationStackArn)
      .optionallyWith(
        customDomain.map(value => CustomDomain.unwrap(value): java.lang.String)
      )(_.customDomain)
      .optionallyWith(
        disableAutomatedBackup.map(value => value: java.lang.Boolean)
      )(_.disableAutomatedBackup)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineModel.map(value => value: java.lang.String))(
        _.engineModel
      )
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(instanceProfileArn.map(value => value: java.lang.String))(
        _.instanceProfileArn
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(keyPair.map(value => value: java.lang.String))(_.keyPair)
      .optionallyWith(maintenanceStatus.map(value => value.unwrap))(
        _.maintenanceStatus
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(serverArn.map(value => value: java.lang.String))(
        _.serverArn
      )
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.Server.ReadOnly =
    zio.aws.opsworkscm.model.Server.wrap(buildAwsValue())
}
object Server {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.opsworkscm.model.Server] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.Server =
      zio.aws.opsworkscm.model.Server(
        associatePublicIpAddress.map(value => value),
        backupRetentionCount.map(value => value),
        serverName.map(value => value),
        createdAt.map(value => value),
        cloudFormationStackArn.map(value => value),
        customDomain.map(value => value),
        disableAutomatedBackup.map(value => value),
        endpoint.map(value => value),
        engine.map(value => value),
        engineModel.map(value => value),
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        engineVersion.map(value => value),
        instanceProfileArn.map(value => value),
        instanceType.map(value => value),
        keyPair.map(value => value),
        maintenanceStatus.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        preferredBackupWindow.map(value => value),
        securityGroupIds.map(value => value),
        serviceRoleArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        subnetIds.map(value => value),
        serverArn.map(value => value)
      )
    def associatePublicIpAddress: Option[Boolean]
    def backupRetentionCount: Option[Integer]
    def serverName: Option[String]
    def createdAt: Option[Timestamp]
    def cloudFormationStackArn: Option[String]
    def customDomain: Option[CustomDomain]
    def disableAutomatedBackup: Option[Boolean]
    def endpoint: Option[String]
    def engine: Option[String]
    def engineModel: Option[String]
    def engineAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def engineVersion: Option[String]
    def instanceProfileArn: Option[String]
    def instanceType: Option[String]
    def keyPair: Option[String]
    def maintenanceStatus: Option[zio.aws.opsworkscm.model.MaintenanceStatus]
    def preferredMaintenanceWindow: Option[TimeWindowDefinition]
    def preferredBackupWindow: Option[TimeWindowDefinition]
    def securityGroupIds: Option[List[String]]
    def serviceRoleArn: Option[String]
    def status: Option[zio.aws.opsworkscm.model.ServerStatus]
    def statusReason: Option[String]
    def subnetIds: Option[List[String]]
    def serverArn: Option[String]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getBackupRetentionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionCount", backupRetentionCount)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCloudFormationStackArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cloudFormationStackArn", cloudFormationStackArn)
    def getCustomDomain: ZIO[Any, AwsError, CustomDomain] =
      AwsError.unwrapOptionField("customDomain", customDomain)
    def getDisableAutomatedBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableAutomatedBackup", disableAutomatedBackup)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineModel", engineModel)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getInstanceProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileArn", instanceProfileArn)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyPair: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getMaintenanceStatus
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.MaintenanceStatus] =
      AwsError.unwrapOptionField("maintenanceStatus", maintenanceStatus)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.opsworkscm.model.ServerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getServerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverArn", serverArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.Server
  ) extends zio.aws.opsworkscm.model.Server.ReadOnly {
    override val associatePublicIpAddress: Option[Boolean] =
      scala.Option(impl.associatePublicIpAddress()).map(value => value: Boolean)
    override val backupRetentionCount: Option[Integer] = scala
      .Option(impl.backupRetentionCount())
      .map(value => zio.aws.opsworkscm.model.primitives.Integer(value))
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.opsworkscm.model.primitives.Timestamp(value))
    override val cloudFormationStackArn: Option[String] =
      scala.Option(impl.cloudFormationStackArn()).map(value => value: String)
    override val customDomain: Option[CustomDomain] = scala
      .Option(impl.customDomain())
      .map(value => zio.aws.opsworkscm.model.primitives.CustomDomain(value))
    override val disableAutomatedBackup: Option[Boolean] =
      scala.Option(impl.disableAutomatedBackup()).map(value => value: Boolean)
    override val endpoint: Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineModel: Option[String] =
      scala.Option(impl.engineModel()).map(value => value: String)
    override val engineAttributes
        : Option[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      scala
        .Option(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val instanceProfileArn: Option[String] =
      scala.Option(impl.instanceProfileArn()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val keyPair: Option[String] =
      scala.Option(impl.keyPair()).map(value => value: String)
    override val maintenanceStatus
        : Option[zio.aws.opsworkscm.model.MaintenanceStatus] = scala
      .Option(impl.maintenanceStatus())
      .map(value => zio.aws.opsworkscm.model.MaintenanceStatus.wrap(value))
    override val preferredMaintenanceWindow: Option[TimeWindowDefinition] =
      scala
        .Option(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val preferredBackupWindow: Option[TimeWindowDefinition] = scala
      .Option(impl.preferredBackupWindow())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceRoleArn: Option[String] =
      scala.Option(impl.serviceRoleArn()).map(value => value: String)
    override val status: Option[zio.aws.opsworkscm.model.ServerStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.opsworkscm.model.ServerStatus.wrap(value))
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serverArn: Option[String] =
      scala.Option(impl.serverArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.Server
  ): zio.aws.opsworkscm.model.Server.ReadOnly = new Wrapper(impl)
}
