package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  EngineAttributeValue,
  EngineAttributeName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EngineAttribute(
    name: Option[EngineAttributeName] = None,
    value: Option[EngineAttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.EngineAttribute = {
    import EngineAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
      .builder()
      .optionallyWith(
        name.map(value => EngineAttributeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => EngineAttributeValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.EngineAttribute.ReadOnly =
    zio.aws.opsworkscm.model.EngineAttribute.wrap(buildAwsValue())
}
object EngineAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.EngineAttribute =
      zio.aws.opsworkscm.model
        .EngineAttribute(name.map(value => value), value.map(value => value))
    def name: Option[EngineAttributeName]
    def value: Option[EngineAttributeValue]
    def getName: ZIO[Any, AwsError, EngineAttributeName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, EngineAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
  ) extends zio.aws.opsworkscm.model.EngineAttribute.ReadOnly {
    override val name: Option[EngineAttributeName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.EngineAttributeName(value)
      )
    override val value: Option[EngineAttributeValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.EngineAttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
  ): zio.aws.opsworkscm.model.EngineAttribute.ReadOnly = new Wrapper(impl)
}
