package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.NodeAssociationStatusToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateNodeResponse(
    nodeAssociationStatusToken: Option[NodeAssociationStatusToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse = {
    import DisassociateNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse
      .builder()
      .optionallyWith(
        nodeAssociationStatusToken.map(value =>
          NodeAssociationStatusToken.unwrap(value): java.lang.String
        )
      )(_.nodeAssociationStatusToken)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly =
    zio.aws.opsworkscm.model.DisassociateNodeResponse.wrap(buildAwsValue())
}
object DisassociateNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DisassociateNodeResponse =
      zio.aws.opsworkscm.model.DisassociateNodeResponse(
        nodeAssociationStatusToken.map(value => value)
      )
    def nodeAssociationStatusToken: Option[NodeAssociationStatusToken]
    def getNodeAssociationStatusToken
        : ZIO[Any, AwsError, NodeAssociationStatusToken] =
      AwsError.unwrapOptionField(
        "nodeAssociationStatusToken",
        nodeAssociationStatusToken
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse
  ) extends zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly {
    override val nodeAssociationStatusToken
        : Option[NodeAssociationStatusToken] = scala
      .Option(impl.nodeAssociationStatusToken())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.NodeAssociationStatusToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse
  ): zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
