package zio.aws.opsworkscm
import zio.aws.opsworkscm.model.{
  DisassociateNodeRequest,
  CreateBackupRequest,
  DescribeEventsRequest,
  ListTagsForResourceRequest,
  DescribeServersRequest,
  DeleteServerRequest,
  ExportServerEngineAttributeRequest,
  StartMaintenanceRequest,
  DescribeNodeAssociationStatusRequest,
  UpdateServerRequest,
  DeleteBackupRequest,
  UntagResourceRequest,
  DescribeAccountAttributesRequest,
  CreateServerRequest,
  UpdateServerEngineAttributesRequest,
  DescribeBackupsRequest,
  AssociateNodeRequest,
  TagResourceRequest,
  RestoreServerRequest
}
import zio.aws.opsworkscm.model.CreateServerResponse.ReadOnly
import software.amazon.awssdk.services.opsworkscm.model.{
  DescribeEventsResponse,
  DisassociateNodeResponse,
  Backup,
  UpdateServerEngineAttributesResponse,
  RestoreServerResponse,
  AssociateNodeResponse,
  DescribeServersResponse,
  UpdateServerResponse,
  StartMaintenanceResponse,
  Tag,
  ListTagsForResourceResponse,
  DeleteServerResponse,
  UntagResourceResponse,
  DescribeBackupsResponse,
  DescribeNodeAssociationStatusResponse,
  CreateBackupResponse,
  DeleteBackupResponse,
  Server,
  ServerEvent,
  TagResourceResponse,
  ExportServerEngineAttributeResponse,
  DescribeAccountAttributesResponse,
  CreateServerResponse
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.opsworkscm.{
  OpsWorksCmAsyncClientBuilder,
  OpsWorksCmAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait OpsWorksCm extends AspectSupport[OpsWorksCm] {
  val api: OpsWorksCmAsyncClient
  def updateServer(
      request: UpdateServerRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly]
  def deleteServer(
      request: DeleteServerRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.DeleteServerResponse.ReadOnly]
  def exportServerEngineAttribute(
      request: ExportServerEngineAttributeRequest
  ): IO[
    AwsError,
    zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly
  ]
  def associateNode(
      request: AssociateNodeRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly]
  def createBackup(
      request: CreateBackupRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly]
  def describeNodeAssociationStatus(
      request: DescribeNodeAssociationStatusRequest
  ): IO[
    AwsError,
    zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly
  ]
  def describeBackups(
      request: DescribeBackupsRequest
  ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Backup.ReadOnly]
  def describeBackupsPaginated(
      request: DescribeBackupsRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly]
  def restoreServer(
      request: RestoreServerRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.UntagResourceResponse.ReadOnly]
  def disassociateNode(
      request: DisassociateNodeRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly]
  def describeServers(
      request: DescribeServersRequest
  ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Server.ReadOnly]
  def describeServersPaginated(
      request: DescribeServersRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly]
  def deleteBackup(
      request: DeleteBackupRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.DeleteBackupResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.ListTagsForResourceResponse.ReadOnly]
  def createServer(request: CreateServerRequest): IO[AwsError, ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.TagResourceResponse.ReadOnly]
  def startMaintenance(
      request: StartMaintenanceRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly]
  def updateServerEngineAttributes(
      request: UpdateServerEngineAttributesRequest
  ): IO[
    AwsError,
    zio.aws.opsworkscm.model.UpdateServerEngineAttributesResponse.ReadOnly
  ]
  def describeAccountAttributes(request: DescribeAccountAttributesRequest): IO[
    AwsError,
    zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly
  ]
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.ServerEvent.ReadOnly]
  def describeEventsPaginated(
      request: DescribeEventsRequest
  ): IO[AwsError, zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly]
}
object OpsWorksCm {
  val live: ZLayer[AwsConfig, java.lang.Throwable, OpsWorksCm] = customized(
    identity
  )
  def customized(
      customization: OpsWorksCmAsyncClientBuilder => OpsWorksCmAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, OpsWorksCm] = managed(
    customization
  ).toLayer
  def managed(
      customization: OpsWorksCmAsyncClientBuilder => OpsWorksCmAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, OpsWorksCm] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = OpsWorksCmAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[OpsWorksCmAsyncClient, OpsWorksCmAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[OpsWorksCmAsyncClient, OpsWorksCmAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new OpsWorksCmImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class OpsWorksCmImpl[R](
      override val api: OpsWorksCmAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends OpsWorksCm
      with AwsServiceBase[R] {
    override val serviceName: String = "OpsWorksCm"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): OpsWorksCmImpl[R1] = new OpsWorksCmImpl(api, newAspect, r)
    def updateServer(
        request: UpdateServerRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest,
        UpdateServerResponse
      ]("updateServer", api.updateServer)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.UpdateServerResponse.wrap)
        .provideEnvironment(r)
    def deleteServer(
        request: DeleteServerRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.DeleteServerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest,
        DeleteServerResponse
      ]("deleteServer", api.deleteServer)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.DeleteServerResponse.wrap)
        .provideEnvironment(r)
    def exportServerEngineAttribute(
        request: ExportServerEngineAttributeRequest
    ): IO[
      AwsError,
      zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest,
      ExportServerEngineAttributeResponse
    ]("exportServerEngineAttribute", api.exportServerEngineAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.wrap)
      .provideEnvironment(r)
    def associateNode(
        request: AssociateNodeRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest,
        AssociateNodeResponse
      ]("associateNode", api.associateNode)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.AssociateNodeResponse.wrap)
        .provideEnvironment(r)
    def createBackup(
        request: CreateBackupRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest,
        CreateBackupResponse
      ]("createBackup", api.createBackup)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.CreateBackupResponse.wrap)
        .provideEnvironment(r)
    def describeNodeAssociationStatus(
        request: DescribeNodeAssociationStatusRequest
    ): IO[
      AwsError,
      zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest,
      DescribeNodeAssociationStatusResponse
    ]("describeNodeAssociationStatus", api.describeNodeAssociationStatus)(
      request.buildAwsValue()
    ).map(zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.wrap)
      .provideEnvironment(r)
    def describeBackups(
        request: DescribeBackupsRequest
    ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Backup.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest,
        DescribeBackupsResponse,
        Backup
      ](
        "describeBackups",
        api.describeBackups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.backups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.opsworkscm.model.Backup.wrap(item))
        .provideEnvironment(r)
    def describeBackupsPaginated(
        request: DescribeBackupsRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest,
        DescribeBackupsResponse
      ]("describeBackups", api.describeBackups)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.DescribeBackupsResponse.wrap)
        .provideEnvironment(r)
    def restoreServer(
        request: RestoreServerRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest,
        RestoreServerResponse
      ]("restoreServer", api.restoreServer)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.RestoreServerResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def disassociateNode(request: DisassociateNodeRequest): IO[
      AwsError,
      zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest,
      DisassociateNodeResponse
    ]("disassociateNode", api.disassociateNode)(request.buildAwsValue())
      .map(zio.aws.opsworkscm.model.DisassociateNodeResponse.wrap)
      .provideEnvironment(r)
    def describeServers(
        request: DescribeServersRequest
    ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Server.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest,
        DescribeServersResponse,
        Server
      ](
        "describeServers",
        api.describeServers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.servers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.opsworkscm.model.Server.wrap(item))
        .provideEnvironment(r)
    def describeServersPaginated(
        request: DescribeServersRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest,
        DescribeServersResponse
      ]("describeServers", api.describeServers)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.DescribeServersResponse.wrap)
        .provideEnvironment(r)
    def deleteBackup(
        request: DeleteBackupRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.DeleteBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest,
        DeleteBackupResponse
      ]("deleteBackup", api.deleteBackup)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.DeleteBackupResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.opsworkscm.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.opsworkscm.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.opsworkscm.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createServer(request: CreateServerRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest,
        CreateServerResponse
      ]("createServer", api.createServer)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.CreateServerResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def startMaintenance(request: StartMaintenanceRequest): IO[
      AwsError,
      zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest,
      StartMaintenanceResponse
    ]("startMaintenance", api.startMaintenance)(request.buildAwsValue())
      .map(zio.aws.opsworkscm.model.StartMaintenanceResponse.wrap)
      .provideEnvironment(r)
    def updateServerEngineAttributes(
        request: UpdateServerEngineAttributesRequest
    ): IO[
      AwsError,
      zio.aws.opsworkscm.model.UpdateServerEngineAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest,
      UpdateServerEngineAttributesResponse
    ]("updateServerEngineAttributes", api.updateServerEngineAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.opsworkscm.model.UpdateServerEngineAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAttributes(
        request: DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.opsworkscm.model.ServerEvent.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest,
        DescribeEventsResponse,
        ServerEvent
      ](
        "describeEvents",
        api.describeEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.serverEvents().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.opsworkscm.model.ServerEvent.wrap(item))
        .provideEnvironment(r)
    def describeEventsPaginated(
        request: DescribeEventsRequest
    ): IO[AwsError, zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest,
        DescribeEventsResponse
      ]("describeEvents", api.describeEvents)(request.buildAwsValue())
        .map(zio.aws.opsworkscm.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
  }
  def updateServer(request: UpdateServerRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.UpdateServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServer(request))
  def deleteServer(request: DeleteServerRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DeleteServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServer(request))
  def exportServerEngineAttribute(
      request: ExportServerEngineAttributeRequest
  ): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.ExportServerEngineAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportServerEngineAttribute(request))
  def associateNode(request: AssociateNodeRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.AssociateNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateNode(request))
  def createBackup(request: CreateBackupRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.CreateBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackup(request))
  def describeNodeAssociationStatus(
      request: DescribeNodeAssociationStatusRequest
  ): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DescribeNodeAssociationStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNodeAssociationStatus(request))
  def describeBackups(request: DescribeBackupsRequest): ZStream[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.Backup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeBackups(request))
  def describeBackupsPaginated(request: DescribeBackupsRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackupsPaginated(request))
  def restoreServer(request: RestoreServerRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreServer(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def disassociateNode(request: DisassociateNodeRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DisassociateNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateNode(request))
  def describeServers(request: DescribeServersRequest): ZStream[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.Server.ReadOnly
  ] = ZStream.serviceWithStream(_.describeServers(request))
  def describeServersPaginated(request: DescribeServersRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServersPaginated(request))
  def deleteBackup(request: DeleteBackupRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DeleteBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackup(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def createServer(
      request: CreateServerRequest
  ): ZIO[zio.aws.opsworkscm.OpsWorksCm, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createServer(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def startMaintenance(request: StartMaintenanceRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMaintenance(request))
  def updateServerEngineAttributes(
      request: UpdateServerEngineAttributesRequest
  ): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.UpdateServerEngineAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServerEngineAttributes(request))
  def describeAccountAttributes(request: DescribeAccountAttributesRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.ServerEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.opsworkscm.OpsWorksCm,
    AwsError,
    zio.aws.opsworkscm.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
}
