package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.{
  LifecycleResource,
  ListLifecyclePoliciesRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLifecyclePoliciesRequest(
    maxResults: Optional[ListLifecyclePoliciesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    resources: Optional[Iterable[LifecycleResource]] = Optional.Absent,
    `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest = {
    import ListLifecyclePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListLifecyclePoliciesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            LifecycleResource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListLifecyclePoliciesRequest.ReadOnly =
    zio.aws.opensearchserverless.model.ListLifecyclePoliciesRequest
      .wrap(buildAwsValue())
}
object ListLifecyclePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListLifecyclePoliciesRequest =
      zio.aws.opensearchserverless.model.ListLifecyclePoliciesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resources.map(value => value),
        `type`
      )
    def maxResults: Optional[ListLifecyclePoliciesRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def resources: Optional[List[LifecycleResource]]
    def `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
    def getMaxResults
        : ZIO[Any, AwsError, ListLifecyclePoliciesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResources: ZIO[Any, AwsError, List[LifecycleResource]] =
      AwsError.unwrapOptionField("resources", resources)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest
  ) extends zio.aws.opensearchserverless.model.ListLifecyclePoliciesRequest.ReadOnly {
    override val maxResults
        : Optional[ListLifecyclePoliciesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .ListLifecyclePoliciesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resources: Optional[List[LifecycleResource]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives
              .LifecycleResource(item)
          }.toList
        )
    override val `type`
        : zio.aws.opensearchserverless.model.LifecyclePolicyType =
      zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest
  ): zio.aws.opensearchserverless.model.ListLifecyclePoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
