package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVpcEndpointResponse(
    createVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.CreateVpcEndpointDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse = {
    import CreateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse
      .builder()
      .optionallyWith(
        createVpcEndpointDetail.map(value => value.buildAwsValue())
      )(_.createVpcEndpointDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly =
    zio.aws.opensearchserverless.model.CreateVpcEndpointResponse
      .wrap(buildAwsValue())
}
object CreateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateVpcEndpointResponse =
      zio.aws.opensearchserverless.model.CreateVpcEndpointResponse(
        createVpcEndpointDetail.map(value => value.asEditable)
      )
    def createVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.CreateVpcEndpointDetail.ReadOnly
    ]
    def getCreateVpcEndpointDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CreateVpcEndpointDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createVpcEndpointDetail",
      createVpcEndpointDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse
  ) extends zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly {
    override val createVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.CreateVpcEndpointDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createVpcEndpointDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.CreateVpcEndpointDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse
  ): zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
