package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  PolicyDocument,
  PolicyName,
  PolicyDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLifecyclePolicyRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[PolicyDescription] = Optional.Absent,
    name: PolicyName,
    policy: PolicyDocument,
    `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest = {
    import CreateLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          PolicyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(PolicyName.unwrap(name): java.lang.String)
      .policy(PolicyDocument.unwrap(policy): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateLifecyclePolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.CreateLifecyclePolicyRequest
      .wrap(buildAwsValue())
}
object CreateLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateLifecyclePolicyRequest =
      zio.aws.opensearchserverless.model.CreateLifecyclePolicyRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        policy,
        `type`
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[PolicyDescription]
    def name: PolicyName
    def policy: PolicyDocument
    def `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getPolicy: ZIO[Any, Nothing, PolicyDocument] = ZIO.succeed(policy)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest
  ) extends zio.aws.opensearchserverless.model.CreateLifecyclePolicyRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val description: Optional[PolicyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.PolicyDescription(value)
        )
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val policy: PolicyDocument =
      zio.aws.opensearchserverless.model.primitives
        .PolicyDocument(impl.policy())
    override val `type`
        : zio.aws.opensearchserverless.model.LifecyclePolicyType =
      zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest
  ): zio.aws.opensearchserverless.model.CreateLifecyclePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
