package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CreateCollectionRequestDescriptionString,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCollectionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[CreateCollectionRequestDescriptionString] =
      Optional.Absent,
    name: CollectionName,
    tags: Optional[Iterable[zio.aws.opensearchserverless.model.Tag]] =
      Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.CollectionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest = {
    import CreateCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          CreateCollectionRequestDescriptionString.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .name(CollectionName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateCollectionRequest.ReadOnly =
    zio.aws.opensearchserverless.model.CreateCollectionRequest
      .wrap(buildAwsValue())
}
object CreateCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.CreateCollectionRequest =
      zio.aws.opensearchserverless.model.CreateCollectionRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[CreateCollectionRequestDescriptionString]
    def name: CollectionName
    def tags: Optional[List[zio.aws.opensearchserverless.model.Tag.ReadOnly]]
    def `type`: Optional[zio.aws.opensearchserverless.model.CollectionType]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription
        : ZIO[Any, AwsError, CreateCollectionRequestDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, CollectionName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest
  ) extends zio.aws.opensearchserverless.model.CreateCollectionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val description
        : Optional[CreateCollectionRequestDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .CreateCollectionRequestDescriptionString(value)
        )
    override val name: CollectionName =
      zio.aws.opensearchserverless.model.primitives.CollectionName(impl.name())
    override val tags
        : Optional[List[zio.aws.opensearchserverless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.Tag.wrap(item)
          }.toList
        )
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.CollectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest
  ): zio.aws.opensearchserverless.model.CreateCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
