package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteCollectionResponse(
    deleteCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.DeleteCollectionDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse = {
    import DeleteCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse
      .builder()
      .optionallyWith(
        deleteCollectionDetail.map(value => value.buildAwsValue())
      )(_.deleteCollectionDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteCollectionResponse
      .wrap(buildAwsValue())
}
object DeleteCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.DeleteCollectionResponse =
      zio.aws.opensearchserverless.model.DeleteCollectionResponse(
        deleteCollectionDetail.map(value => value.asEditable)
      )
    def deleteCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.DeleteCollectionDetail.ReadOnly
    ]
    def getDeleteCollectionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.DeleteCollectionDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteCollectionDetail",
      deleteCollectionDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse
  ) extends zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly {
    override val deleteCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.DeleteCollectionDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteCollectionDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.DeleteCollectionDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse
  ): zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
