package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSecurityConfigResponse(
    securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse = {
    import CreateSecurityConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse
      .builder()
      .optionallyWith(securityConfigDetail.map(value => value.buildAwsValue()))(
        _.securityConfigDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly =
    zio.aws.opensearchserverless.model.CreateSecurityConfigResponse
      .wrap(buildAwsValue())
}
object CreateSecurityConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateSecurityConfigResponse =
      zio.aws.opensearchserverless.model.CreateSecurityConfigResponse(
        securityConfigDetail.map(value => value.asEditable)
      )
    def securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ]
    def getSecurityConfigDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfigDetail", securityConfigDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse
  ) extends zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly {
    override val securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityConfigDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityConfigDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse
  ): zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly =
    new Wrapper(impl)
}
