package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetEffectiveLifecyclePolicyResponse(
    effectiveLifecyclePolicyDetails: Optional[Iterable[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail
    ]] = Optional.Absent,
    effectiveLifecyclePolicyErrorDetails: Optional[Iterable[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse = {
    import BatchGetEffectiveLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        effectiveLifecyclePolicyDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.effectiveLifecyclePolicyDetails)
      .optionallyWith(
        effectiveLifecyclePolicyErrorDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.effectiveLifecyclePolicyErrorDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse
      .wrap(buildAwsValue())
}
object BatchGetEffectiveLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse =
      zio.aws.opensearchserverless.model
        .BatchGetEffectiveLifecyclePolicyResponse(
          effectiveLifecyclePolicyDetails.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          effectiveLifecyclePolicyErrorDetails.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def effectiveLifecyclePolicyDetails: Optional[List[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail.ReadOnly
    ]]
    def effectiveLifecyclePolicyErrorDetails: Optional[List[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.ReadOnly
    ]]
    def getEffectiveLifecyclePolicyDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "effectiveLifecyclePolicyDetails",
      effectiveLifecyclePolicyDetails
    )
    def getEffectiveLifecyclePolicyErrorDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "effectiveLifecyclePolicyErrorDetails",
      effectiveLifecyclePolicyErrorDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse
  ) extends zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse.ReadOnly {
    override val effectiveLifecyclePolicyDetails: Optional[List[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveLifecyclePolicyDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail
            .wrap(item)
        }.toList
      )
    override val effectiveLifecyclePolicyErrorDetails: Optional[List[
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveLifecyclePolicyErrorDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse
  ): zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
