package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAccountSettingsRequest(
    capacityLimits: Optional[
      zio.aws.opensearchserverless.model.CapacityLimits
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest = {
    import UpdateAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest
      .builder()
      .optionallyWith(capacityLimits.map(value => value.buildAwsValue()))(
        _.capacityLimits
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateAccountSettingsRequest.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateAccountSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateAccountSettingsRequest =
      zio.aws.opensearchserverless.model.UpdateAccountSettingsRequest(
        capacityLimits.map(value => value.asEditable)
      )
    def capacityLimits
        : Optional[zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly]
    def getCapacityLimits: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly
    ] = AwsError.unwrapOptionField("capacityLimits", capacityLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest
  ) extends zio.aws.opensearchserverless.model.UpdateAccountSettingsRequest.ReadOnly {
    override val capacityLimits
        : Optional[zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityLimits())
        .map(value =>
          zio.aws.opensearchserverless.model.CapacityLimits.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest
  ): zio.aws.opensearchserverless.model.UpdateAccountSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
