package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.Resource
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EffectiveLifecyclePolicyErrorDetail(
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    resource: Optional[Resource] = Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail = {
    import EffectiveLifecyclePolicyErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(
        resource.map(value => Resource.unwrap(value): java.lang.String)
      )(_.resource)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.ReadOnly =
    zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
      .wrap(buildAwsValue())
}
object EffectiveLifecyclePolicyErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail =
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        resource.map(value => value),
        `type`.map(value => value)
      )
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def resource: Optional[Resource]
    def `type`: Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getResource: ZIO[Any, AwsError, Resource] =
      AwsError.unwrapOptionField("resource", resource)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
  ) extends zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.ReadOnly {
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val resource: Optional[Resource] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.Resource(value)
      )
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail
  ): zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.ReadOnly =
    new Wrapper(impl)
}
