package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{Resource, PolicyName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EffectiveLifecyclePolicyDetail(
    noMinRetentionPeriod: Optional[Boolean] = Optional.Absent,
    policyName: Optional[PolicyName] = Optional.Absent,
    resource: Optional[Resource] = Optional.Absent,
    resourceType: Optional[zio.aws.opensearchserverless.model.ResourceType] =
      Optional.Absent,
    retentionPeriod: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail = {
    import EffectiveLifecyclePolicyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail
      .builder()
      .optionallyWith(
        noMinRetentionPeriod.map(value => value: java.lang.Boolean)
      )(_.noMinRetentionPeriod)
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        resource.map(value => Resource.unwrap(value): java.lang.String)
      )(_.resource)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(retentionPeriod.map(value => value: java.lang.String))(
        _.retentionPeriod
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail.ReadOnly =
    zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail
      .wrap(buildAwsValue())
}
object EffectiveLifecyclePolicyDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail =
      zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail(
        noMinRetentionPeriod.map(value => value),
        policyName.map(value => value),
        resource.map(value => value),
        resourceType.map(value => value),
        retentionPeriod.map(value => value),
        `type`.map(value => value)
      )
    def noMinRetentionPeriod: Optional[Boolean]
    def policyName: Optional[PolicyName]
    def resource: Optional[Resource]
    def resourceType: Optional[zio.aws.opensearchserverless.model.ResourceType]
    def retentionPeriod: Optional[String]
    def `type`: Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType]
    def getNoMinRetentionPeriod: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("noMinRetentionPeriod", noMinRetentionPeriod)
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getResource: ZIO[Any, AwsError, Resource] =
      AwsError.unwrapOptionField("resource", resource)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.opensearchserverless.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getRetentionPeriod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail
  ) extends zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail.ReadOnly {
    override val noMinRetentionPeriod: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.noMinRetentionPeriod())
      .map(value => value: Boolean)
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.PolicyName(value)
      )
    override val resource: Optional[Resource] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.Resource(value)
      )
    override val resourceType
        : Optional[zio.aws.opensearchserverless.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.opensearchserverless.model.ResourceType.wrap(value)
        )
    override val retentionPeriod: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPeriod())
      .map(value => value: String)
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail
  ): zio.aws.opensearchserverless.model.EffectiveLifecyclePolicyDetail.ReadOnly =
    new Wrapper(impl)
}
