package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSecurityPolicyResponse(
    securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse = {
    import CreateSecurityPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse
      .builder()
      .optionallyWith(securityPolicyDetail.map(value => value.buildAwsValue()))(
        _.securityPolicyDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse
      .wrap(buildAwsValue())
}
object CreateSecurityPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse =
      zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse(
        securityPolicyDetail.map(value => value.asEditable)
      )
    def securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ]
    def getSecurityPolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ] = AwsError.unwrapOptionField("securityPolicyDetail", securityPolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse
  ) extends zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly {
    override val securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityPolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityPolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse
  ): zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
