package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetEffectiveLifecyclePolicyRequest(
    resourceIdentifiers: Iterable[
      zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest = {
    import BatchGetEffectiveLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest
      .builder()
      .resourceIdentifiers(resourceIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest
      .wrap(buildAwsValue())
}
object BatchGetEffectiveLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest =
      zio.aws.opensearchserverless.model
        .BatchGetEffectiveLifecyclePolicyRequest(resourceIdentifiers.map {
          item =>
            item.asEditable
        })
    def resourceIdentifiers: List[
      zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier.ReadOnly
    ]
    def getResourceIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier.ReadOnly
    ]] = ZIO.succeed(resourceIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest
  ) extends zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest.ReadOnly {
    override val resourceIdentifiers: List[
      zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier.ReadOnly
    ] = impl
      .resourceIdentifiers()
      .asScala
      .map { item =>
        zio.aws.opensearchserverless.model.LifecyclePolicyResourceIdentifier
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest
  ): zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
