package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyStats(
    retentionPolicyCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyStats = {
    import LifecyclePolicyStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyStats
      .builder()
      .optionallyWith(retentionPolicyCount.map(value => value: java.lang.Long))(
        _.retentionPolicyCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.LifecyclePolicyStats.ReadOnly =
    zio.aws.opensearchserverless.model.LifecyclePolicyStats
      .wrap(buildAwsValue())
}
object LifecyclePolicyStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.LifecyclePolicyStats =
      zio.aws.opensearchserverless.model
        .LifecyclePolicyStats(retentionPolicyCount.map(value => value))
    def retentionPolicyCount: Optional[Long]
    def getRetentionPolicyCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retentionPolicyCount", retentionPolicyCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyStats
  ) extends zio.aws.opensearchserverless.model.LifecyclePolicyStats.ReadOnly {
    override val retentionPolicyCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPolicyCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyStats
  ): zio.aws.opensearchserverless.model.LifecyclePolicyStats.ReadOnly =
    new Wrapper(impl)
}
