package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLifecyclePolicyResponse(
    lifecyclePolicyDetail: Optional[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse = {
    import CreateLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        lifecyclePolicyDetail.map(value => value.buildAwsValue())
      )(_.lifecyclePolicyDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse
      .wrap(buildAwsValue())
}
object CreateLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse =
      zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse(
        lifecyclePolicyDetail.map(value => value.asEditable)
      )
    def lifecyclePolicyDetail: Optional[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ]
    def getLifecyclePolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ] =
      AwsError.unwrapOptionField("lifecyclePolicyDetail", lifecyclePolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse
  ) extends zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse.ReadOnly {
    override val lifecyclePolicyDetail: Optional[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecyclePolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.LifecyclePolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse
  ): zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
